import { StarXpandCommand } from "star-io10-web";
export class ReceiptSample06_PharmacyStore2_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleLineSpace(3.0)
            .actionPrintImage(
              new StarXpandCommand.Printer.ImageParameter("logo_01.png", 300),
            )
            .actionPrintText("${address}\n" + "${telephone_number}")
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionFeedLine(1)
            .actionPrintText("208            7820   0021")
            .styleHorizontalPositionTo(0.0)
            .actionPrintText(
              "${datetime}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                48,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleBold(true)
            .actionPrintText("<< BUY 1 GET 1 EQUAL/LESS VALUE 50% OFF >>\n")
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .styleBold(false)
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list1.name}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(48),
                )
                .actionPrintText(
                  "    ${item_list1.product_number}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(30),
                )
                .actionPrintText(" ")
                .actionPrintText(
                  "${item_list1.tax_mark}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .actionPrintText(
                  "${item_list1.price%.2f}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    10,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText(
                  " ${item_list1.remarks}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(6),
                )
                .actionPrintText(
                  "${item_list1.detail1}" +
                    "${item_list1.detail2}" +
                    "${item_list1.detail3}",
                ),
            )
            .actionPrintText(
              "************************************************\n",
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list2.name}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(48),
                )
                .actionPrintText(
                  "    ${item_list2.product_number}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(30),
                )
                .actionPrintText(" ")
                .actionPrintText(
                  "${item_list2.tax_mark}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .actionPrintText(
                  "${item_list2.price%.2f}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    10,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText(
                  " ${item_list2.remarks}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(6),
                )
                .actionPrintText(
                  "${item_list2.detail1}" +
                    "${item_list2.detail2}" +
                    "${item_list2.detail3}" +
                    "${item_list2.detail4}",
                ),
            )
            .actionFeedLine(1)
            .actionPrintText("    SUBTOTAL")
            .actionPrintText(
              "${subtotal%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                30,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("    SALES TAX A=6.75%")
            .actionPrintText(
              "${sales_tax%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                21,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .actionPrintText("    TOTAL")
            .actionPrintText(
              "${total_price%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                33,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText(
              "    ${payment_method}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "${payment_amount%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                18,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("    CHANGE")
            .actionPrintText(
              "${change%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                32,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(3)
            .actionPrintText("MYSTAR SAVINGS")
            .actionPrintText(
              "${my_serving%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                28,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("MFG COUPON SAVINGS")
            .actionPrintText(
              "${mfg_serving%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .actionPrintText("THANK YOU FOR SHOPPING AT STAR SHOP\n")
            .actionFeedLine(1)
            .actionPrintText("${note}\n")
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText("RFN# ${rfn}\n")
            .actionPrintBarcode(
              new StarXpandCommand.Printer.BarcodeParameter(
                "${barcode}",
                StarXpandCommand.Printer.BarcodeSymbology.Code128,
              ).setBarDots(1),
            )
            .actionFeedLine(1)
            .actionPrintText(
              "************************************************\n",
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "address" : "123 Star Road, City,\\nState 12345",
    "telephone_number" : "012-345-67890",
    "datetime" : "01/24/2023 12:43 PM",
    "staff_name" : "John Smith",
    "rfn" : "0913-8279-2597-0104-2420",
    "item_list1" : [
        {
            "name" : "STAR RAZOR",
            "product_number" : "1111111111",
            "tax_mark" : "A",
            "price" : 13.49,
            "remarks" : "",
            "detail1" : "    RETURN VALUE 10.11\\n"
        },
        {
            "name" : "STAR RAZOR",
            "product_number" : "1111111111",
            "tax_mark" : "A",
            "price" : 13.49,
            "remarks" : "",
            "detail1" : "    RETURN VALUE 10.11\\n",
            "detail2" : "    MYSTAR SAVINGS 6.75\\n",
            "detail3" : "    RETURN VALUE 10.12\\n"
        }
    ],
    "item_list2" : [
        {
            "name" : "STAR DIAPER",
            "product_number" : "2222222222",
            "tax_mark" : "A",
            "price" : 6.49,
            "remarks" : "SALE",
            "detail1" : "    REGULAR PRICE 12.99 or 2/20.00\\n",
            "detail2" : "    SAVINGS 6.50\\n",
            "detail3" : "    RETURN VALUE 6.49\\n"
        },
        {
            "name" : "STAR WHITENING 4.80Z",
            "product_number" : "3333333333",
            "tax_mark" : "A",
            "price" : 5.98,
            "remarks" : "SALE",
            "detail1" : "    2 @ 2.99\\n",
            "detail2" : "    REGULAR PRICE 3.79\\n",
            "detail3" : "    MYSTAR SAVINGS 1.60\\n",
            "detail4" : "    RETURN VALUE 2.99 ea\\n"
        }
    ],
    "subtotal" : 21.7,
    "sales_tax" : 2.21,
    "total_price" : 23.91,
    "payment_method" : "CASH",
    "payment_amount" : 23.91,
    "change" : 0,
    "my_serving" : 6.87,
    "mfg_serving" : 15.0,
    "barcode" : "0123456789012345678901234567890123456789",
    "note" : "REDEEM $50 STAR CASH REWARDS ON YOUR NEXT PURCHASE! STAR CASH REWARDS CANNOT BE REDEEMED ON SOME ITEMS. FOR FULL DETAILS SEE MYSTAR.COM",
    "rfn" : "1171-3217-8279-2101-2403"
}`,
    );
  }
}
